// Header File
// Created 31/12/2003; 15:11:48
//Gestion du Bonus Double Racket

//Interruption
#define INT1_DOUBLE_RACKET_ANIM								20
#define __INT1_DOUBLE_RACKET_ANIM_FREQUENCY		2570
static unsigned short __COUNTER_DOUBLE_RACKET_ANIM=0;

#define Bonus_AddRacket(x) 					CREATE_ANIM_DOUBLE_RACKET(x)
#define Bonus_DeleteRacket(x)				DESTROY_ANIM_DOUBLE_RACKET(x)

BOOL StartIntDoubleRacket=FALSE;

//Prototypes
void DestroyDoubleRacket (unsigned char item);

//Crer l'animation
void CREATE_ANIM_DOUBLE_RACKET (unsigned char item)
{
	if (Racket [item]->double_racket || Racket [item]->isDoubleRacket) return;
	
	StartIntDoubleRacket=FALSE;
	
	Racket [item]->double_xpos=15;
	
	Racket [item]->double_racket_anim=TRUE;
	Racket [item]->double_dir=1;
	
	StartIntDoubleRacket=TRUE;
}

//Dtruire animation
void DESTROY_ANIM_DOUBLE_RACKET (unsigned char item)
{
	if (!Racket [item]->double_racket) return;
	
	StartIntDoubleRacket=FALSE;
	
	DestroyDoubleRacket (item);
	
	Racket [item]->double_xpos=36;
	
	Racket [item]->double_racket_anim=TRUE;
	Racket [item]->double_dir=-2;
	
	StartIntDoubleRacket=TRUE;
}

//Dessine Double racket
void DrawDoubleRacket_anim (void)
{
	short x;
	
	//Parcours rackets
	for (int i=0;i<nbrRacket;i++)
	{
		//Si animation
		if (Racket [i]->double_racket_anim)
		{
			//Dpassement cran
			if ((Racket [i]->xpos+Racket [i]->double_xpos+28)>GAME_WIDTH2)
				x=GAME_WIDTH2-29;
			else
				x=Racket [i]->xpos+Racket [i]->double_xpos;
			
			//Dessine racket
			FastGraySprite32_MASK_R (x,Racket [i]->ypos, 9, SPRITE_RACKETS [1][0],ScreenBuffer);	
		}
	}
}

//Ajoute la double raquette
void AddDoubleRacket (unsigned char item)
{
	//Gestion erreur
	if ((Racket [item]->size!=RACKET_NORMAL) || (Racket [item]->colle) || (Racket [item]->ghost)) return;
	
	Racket [item]->double_racket=TRUE;
	
	//Crer la raquette et identification
	NewRacket (Racket [item]->xpos+36,Racket [item]->ypos,RACKET_NORMAL,DEFAULT_SPEED_RACKETS);
	Racket [nbrRacket-1]->isDoubleRacket=TRUE;
	Racket [nbrRacket-1]->parent=item;
	Racket [item]->double_racket_n=nbrRacket-1;	
}

//Dtruit double racket
void DestroyDoubleRacket (unsigned char item)
{		
	//Efface Double Racket
	DestroyRacket (Racket [item]->double_racket_n);
	Racket [item]->double_racket=FALSE;
}